/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.task.TaskNTP;
import oracle.ops.verification.framework.util.VerificationUtil;

class sTaskNTP {
    final String NTP_CONFIG_FILE = "/etc/ntp.conf";
    final String NTP_DAEMON_NAME = "ntpd";
    final String NTP_QUERY_COMMAND = "/usr/sbin/ntpq -p";
    final String CV_NTP_CONF_FILE = "CV_NTP_CONF_FILE";
    final String CV_NTP_DAEMON_NAME = "CV_NTP_DAEMON_NAME";
    final String NTP_SLEWING_OPTION = "-x";
    final String NTPD_COMMANDLINE_QUERY = "/bin/ps -o cmd h -C ";
    final String NTPD_STARTUP_OPTION_QUERY = "grep \"^OPTIONS=\" ";
    final String NTPD_STARTUP_OPTION_QUERY_SUSE = "grep \"^NTPD_OPTIONS=\" ";
    final String NTPD_STARTUP_CONFIG_FILE = "/etc/sysconfig/ntpd";
    final String NTPD_STARTUP_CONFIG_FILE_SUSE = "/etc/sysconfig/ntp";
    private boolean m_isNTPQSupported = true;
    private TaskNTP m_genTask;

    sTaskNTP(TaskNTP genTask) {
        String osName = VerificationUtil.getCurrentOS().toLowerCase();
        if (osName.contentEquals("aix")) {
            this.m_isNTPQSupported = false;
        }
        this.m_genTask = genTask;
    }

    sTaskNTP() {
        String osName = VerificationUtil.getCurrentOS().toLowerCase();
        if (osName.contentEquals("aix")) {
            this.m_isNTPQSupported = false;
        }
    }

    public String getNTPConfigFile() {
        String cfile = System.getProperty("CV_NTP_CONF_FILE");
        if (cfile != null && cfile.trim().length() > 0) {
            return cfile;
        }
        return "/etc/ntp.conf";
    }

    public List<String> getNTPDaemonNames() {
        ArrayList<String> retList = new ArrayList<String>();
        String dmn = System.getProperty("CV_NTP_DAEMON_NAME");
        if (dmn != null && dmn.trim().length() > 0) {
            retList.add(dmn);
        } else {
            retList.add("ntpd");
        }
        return retList;
    }

    public String getNTPDaemonName() {
        String ret = this.getNTPDaemonNames().get(0);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public String getNTPQueryCommand() {
        return "/usr/sbin/ntpq -p";
    }

    public String getNTPDCommandLine(String queryType) {
        if (queryType.equalsIgnoreCase("commandline")) {
            return "/bin/ps -o cmd h -C " + this.getNTPDaemonName();
        }
        if (VerificationUtil.getUniqueDistributionID().startsWith("SUSE")) {
            return "grep \"^NTPD_OPTIONS=\" " + this.getNTPDBootConfigFile();
        }
        return "grep \"^OPTIONS=\" " + this.getNTPDBootConfigFile();
    }

    public String getNTPDBootConfigFile() {
        if (VerificationUtil.getUniqueDistributionID().startsWith("SUSE")) {
            return "/etc/sysconfig/ntp";
        }
        return "/etc/sysconfig/ntpd";
    }

    public String getNTPDSlewingOption() {
        return "-x";
    }

    public String[] parseNTPQueryOutput(String ntpqOutput) {
        String[] lineArray = ntpqOutput.split("\n");
        String[] tsArray = null;
        if (lineArray.length > 2) {
            tsArray = new String[lineArray.length - 2];
            for (int i = 2; i < lineArray.length; ++i) {
                tsArray[i - 2] = lineArray[i];
            }
        }
        return tsArray;
    }

    public String getIDFromNTPOutput(String tsline) {
        if (tsline.length() < 2) {
            return null;
        }
        String[] tsEntries = tsline.substring(1).split("\\s+");
        if (tsEntries.length >= 2) {
            return tsEntries[1];
        }
        return null;
    }

    public float getNTPOffsetLimit() {
        String maxOffset = VDMUtil.getNTPOffsetLimit();
        Trace.out((String)("using " + maxOffset + " as threshold limit"));
        float f = Float.parseFloat(maxOffset);
        return f;
    }

    public boolean parseNTPDCommandLine(String cmdline, String queryType) {
        String slewingOptionRegx = "-\\S*x\\S*";
        String slewingOptionRegx2 = "\\S*=\"-\\S*x\\S*";
        if (cmdline != null && cmdline.length() != 0) {
            String[] cmdlineArr = cmdline.split("\\s");
            for (int i = 0; i < cmdlineArr.length; ++i) {
                if (cmdlineArr[i].matches(slewingOptionRegx)) {
                    return true;
                }
                if (!cmdlineArr[i].matches(slewingOptionRegx2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isNTPQSupported() {
        return this.m_isNTPQSupported;
    }

    public String getCfgFileToSearch() {
        return new String("/etc/services");
    }
}

